#include <iostream>
#include <vector>
#include <algorithm>
#include <utility>
using namespace std;

vector<int> najvecidesni(vector<int> a)
{
	int n = a.size();
	vector<int> stack;
	vector<int> resenje;
	for (size_t i = 0; i < n; i++)
		resenje.push_back(-1);
	for (size_t i = 0; i < n; i++)
	{
		if (stack.size() == 0 || a[stack.back()] > a[i] )
		{
			stack.push_back(i);
		}
		else
		{
			int j = stack.size() - 1;
			while (j >= 0 && a[stack[j]] <= a[i])
			{				
				resenje[stack[j]] = i;
				stack.pop_back();
				j--;
			}
			stack.push_back(i);
		}
	}
	return resenje;
}
vector<int> prvivecilevi(vector<int> a)
{
	int n = a.size();
	vector<int> resenja, stack;
	for (size_t i = 0; i < n; i++)
		resenja.push_back(-1);
	for (int i = n - 1; i > -1; i--)
	{		
		
		if (stack.size() == 0 || a[stack.back()] > a[i])
			stack.push_back(i);		
		else
		{	
			int j = stack.size() - 1;
			
			while (j >= 0 && a[stack[j]] <= a[i])
			{
				resenja[stack[j]] = i;
				stack.pop_back();
				j--;
			}
			stack.push_back(i);
		}
	}
	return resenja;
}
vector<int> najbliziveci(vector<int> visine,vector<int> razdaljine)
{
	vector<int> desno = najvecidesni(visine);
	vector<int> levo = prvivecilevi(visine);
	vector<int> resenja;
	int n = visine.size();
	int l, d,delsl = 0,delsd = 0,delhd = 0,delhl = 0, razlikad = 2147483647, razlikal = 2147483647;
	for (int i = 0; i < n; i++)
	{
		l = levo[i];
		d = desno[i];
		if (d != -1)
		{
			for (int j = i; j < d; j++)
				delsd += razdaljine[j];
			delhd = visine[d] - visine[i];
			razlikad = delsd - delhd;
		}
		if (l != -1)
		{
			for (int j = i - 1; j >= l; j--)
				delsl += razdaljine[j];
			delhl = visine[l] - visine[i];
			razlikal = delsl - delhl;
		}
		if (d == -1 && l == -1)
			resenja.push_back(-1);
		else
		{			
				if (razlikad == 0)
					razlikad = razdaljine[i];
				if (razlikal == 0)
					razlikal = razdaljine[i - 1];
				resenja.push_back(min(razlikad, razlikal));
		}
			
		delsd = 0, delsl = 0,razlikad = 2147483647,razlikal = 2147483647;
	}
	return resenja;
}


template<typename T1, typename T2>
class DualVectorQuickSort {
private:
	static const int CUTOFF = 16;

	// Insertion sort for small subarrays
	static void insertionSort(std::vector<T1>& vec1, std::vector<T2>& vec2,
		int lo, int hi) {
		for (int i = lo + 1; i <= hi; ++i) {
			T1 key1 = vec1[i];
			T2 key2 = vec2[i];
			int j = i - 1;

			while (j >= lo && vec1[j] > key1) {
				vec1[j + 1] = vec1[j];
				vec2[j + 1] = vec2[j];
				--j;
			}
			vec1[j + 1] = key1;
			vec2[j + 1] = key2;
		}
	}

	// Median of three for pivot selection
	static int median3(std::vector<T1>& vec, int a, int b, int c) {
		if (vec[a] < vec[b]) {
			if (vec[b] < vec[c]) return b;
			return (vec[a] < vec[c]) ? c : a;
		}
		else {
			if (vec[c] < vec[b]) return b;
			return (vec[c] < vec[a]) ? c : a;
		}
	}

	// Three-way partition (Bentley-McIlroy)
	static void quickSortImpl(std::vector<T1>& vec1, std::vector<T2>& vec2,
		int lo, int hi) {
		int n = hi - lo + 1;

		// Use insertion sort for small arrays
		if (n <= CUTOFF) {
			insertionSort(vec1, vec2, lo, hi);
			return;
		}

		// Choose pivot using median-of-3 or Tukey ninther
		int pivotIdx;
		if (n <= 40) {
			pivotIdx = median3(vec1, lo, lo + n / 2, hi);
		}
		else {
			int eps = n / 8;
			int mid = lo + n / 2;
			int m1 = median3(vec1, lo, lo + eps, lo + 2 * eps);
			int m2 = median3(vec1, mid - eps, mid, mid + eps);
			int m3 = median3(vec1, hi - 2 * eps, hi - eps, hi);
			pivotIdx = median3(vec1, m1, m2, m3);
		}

		std::swap(vec1[lo], vec1[pivotIdx]);
		std::swap(vec2[lo], vec2[pivotIdx]);

		// 3-way partitioning
		T1 pivot = vec1[lo];
		int i = lo, j = hi + 1;
		int p = lo, q = hi + 1;

		while (true) {
			while (++i <= hi && vec1[i] < pivot);
			while (vec1[--j] > pivot && j > lo);

			if (i >= j) break;

			std::swap(vec1[i], vec1[j]);
			std::swap(vec2[i], vec2[j]);

			if (vec1[i] == pivot) {
				++p;
				std::swap(vec1[p], vec1[i]);
				std::swap(vec2[p], vec2[i]);
			}
			if (vec1[j] == pivot) {
				--q;
				std::swap(vec1[q], vec1[j]);
				std::swap(vec2[q], vec2[j]);
			}
		}

		std::swap(vec1[lo], vec1[j]);
		std::swap(vec2[lo], vec2[j]);

		i = j + 1;
		j = j - 1;

		for (int k = lo + 1; k <= p; ++k, --j) {
			std::swap(vec1[k], vec1[j]);
			std::swap(vec2[k], vec2[j]);
		}
		for (int k = hi; k >= q; --k, ++i) {
			std::swap(vec1[k], vec1[i]);
			std::swap(vec2[k], vec2[i]);
		}

		quickSortImpl(vec1, vec2, lo, j);
		quickSortImpl(vec1, vec2, i, hi);
	}

public:
	static void sort(std::vector<T1>& vec1, std::vector<T2>& vec2) {
		if (vec1.size() != vec2.size() || vec1.empty()) return;
		quickSortImpl(vec1, vec2, 0, vec1.size() - 1);
	}
};

// Convenience function
template<typename T1, typename T2>
void quickSortDual(std::vector<T1>& vec1, std::vector<T2>& vec2) {
	DualVectorQuickSort<T1, T2>::sort(vec1, vec2);
}
int main()
{
	int n;
	cin >> n;

	vector<int> visine;
	vector<int> razdaljine;
	int pre1,pre2;
	for (size_t i = 0; i < n; i++)
	{
		int temp;
		cin >> temp;
		razdaljine.push_back(temp);
	}
	for (size_t i = 0; i < n; i++)
	{
		int temp;
		cin >> temp;
		visine.push_back(temp);
	}
	quickSortDual(razdaljine, visine);
	pre1 = razdaljine[0];
	vector<int> razda;
	for (size_t i = 1; i < n; i++)
	{
		razda.push_back(razdaljine[i] - pre1);
		pre1 = razdaljine[i];		
	}

	vector<int> resenja = najbliziveci(visine, razda);
	cout << resenja[0];
	int k = resenja.size();
	for (size_t i = 1; i < k; i++)
	{
		cout << '\n' << resenja[i];
	}
}